-- ==========================================
-- Paintball SWEP script by mblunk
-- ==========================================
-- Formatted for easiest viewing in Notepad++
-- ==========================================
-- Here it goes:
-- ==========================================

-- ==========================================
-- On action functions
-- ==========================================
DECAL_PAINT_PINK = 95
function onPickup( playerid )		-- When the player picks this weapon up...
end

function onDrop( playerid )			-- When the player drops it... (when he dies with this weapon out)
end

function onRemove()					-- When this weapon is deleted from the ground...
end

function Deploy()					-- When the player swaps to this weapon...
end

function Holster()					-- When the player swaps away from this weapon...
end

function onInit()					-- When this script is loaded...
_SWEPSetSound( MyIndex, "single_shot", "Weapon_Pistol.Empty" )	-- Sets the sound
_EntPrecacheModel("models/Shadow/paintball.mdl")
end

function onThink()					-- Called every frame
end

function onPrimaryAttack()			-- When the player hits primary fire...
local pos   = _PlayerGetShootPos( Owner )	-- Sets 'pos' to where the player is
local ang   = _PlayerGetShootAng( Owner )	-- Sets 'ang' towhere the player is looking
local force = 50000000000000
local power = vecMul(ang,vector3(force,force,force))
local propName = "models/Shadow/paintball.mdl"
local paintball = _EntCreate( "prop_physics" )
_phys.EnableDrag( paintball, false )
_EntSetOwner( paintball, Owner )
_EntitySetPhysicsAttacker( paintball, Owner )
_EntSetPos( paintball, vecAdd( pos, vecMul( ang, vector3( 32, 32, 32 ) ) ) )
_EntSetVelocity( paintball, power )
_EntSetAng( paintball, ang )
_EntSetModel( paintball, propName )
_EntSetKeyValue( paintball, "physdamagescale", 1000 )
_EntSetKeyValue( paintball, "health", 1 )
_EntFire( paintball, "addoutput", "onhealthchanged !self,kill", "0")
_EntSpawn( paintball )
_EntSetMaterial (paintball, "models/debug/debugwhite")
_EntFire( paintball, "color", "255 0 0", "0")
_phys.EnableGravity( paintball, false )
_RunString( "AddTimer(0.1,1,_phys.EnableGravity,"..paintball..",true)" )
_RunString( "AddTimer(0.16,1,_phys.EnableGravity,"..paintball..",false)" )
_RunString( "AddTimer(0.21,1,_phys.EnableGravity,"..paintball..",true)" )
_RunString( "AddTimer(0.25,1,_phys.EnableGravity,"..paintball..",false)" )
_RunString( "AddTimer(0.28,1,_phys.EnableGravity,"..paintball..",true)" )
_PhysApplyForce( paintball, vecMul( _PlayerGetShootAng( Owner ), vector3( force, force, force ) ) )
_TraceLine( pos, ang, 4096, Owner )
if _TraceHit()==true then
_MakeDecal( DECAL_PAINT_PINK )
end
_SWEPUseAmmo( MyIndex, 0, 1)
end

function onSecondaryAttack()		-- When the player hits secondary fire...	
end

function onReload()					-- When the player hits reload... (Keep the return true, or change to false to not allow the user to reload)
return true
end

-- ==========================================
-- Basic Weapon Display Settings:
-- ==========================================
function getHUDMaterial()			return "gmod/SWEP/default"; end 				-- The weapon's picture in the HUD weapons browser
function getDeathIcon()				return "swep_default"; end 						-- The picture of the gun you killed someone with in top right corner (swep_default is the Pac-Man-like logo for Gmod)
function getWeaponSwapHands() 		return true; end 								-- Return true if you want the player to hold the weapon right-handed, and false if you them to hold it left-handed
function getWeaponFOV() 			return 54; end 									-- Feild of veiw (a higher number makes the gun zoom away from you)
function getWeaponSlot() 			return 1; end 									-- Weapon slot (0-5) 0=crowbar, 1=pistol, 2=smg, 3=shotgun, 4=grenade, 5=pheropod (bugbait)
function getWeaponSlotPos() 		return 2; end 									-- Slot position (0-infinity, make sure it won't cover up existing weapons though) 0=crowbar, 1=stunstick, 2=grav gun, 3=physgun, etc.
function getViewModel() 			return "models/weapons/v_smg_mp5.mdl"; end 	-- The view model (What it looks like when it's in your hands)
function getWorldModel()			return "models/weapons/w_smg_mp5.mdl"; end 	-- The world model (What it looks like when it is spawned on the ground)
function getAnimPrefix()			return "pistol"; end 							-- How the player holds the weapon (pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade)
-- ==========================================
-- Basic Attributes:
-- ==========================================
function getFiresUnderwater() 		return true; end 	-- Can it shoot underwater?
function getReloadsSingly() 		return false; end 	-- Reload after each shot? (like a shotgun)
-- ==========================================
-- Primary Fire Settings:
-- ==========================================
function getDamage() 					return 15; end 			-- Primary fire damage, per bullet
function getPrimaryShotDelay() 			return 0.1; end 		-- Delay between primary fire shots (in seconds)
function getPrimaryIsAutomatic() 		return true; end 		-- Is primary fire automatic? (can you hold down the mouse and it will fire repeatedly?)
function getNumShotsPrimary()			return 1; end 			-- Number of bullets per shot (The HL2 shotgun uses 7)
function getMaxClipPrimary() 			return 200; end 			-- How much primary ammo each clip can hold before you have to reload
function getDefClipPrimary() 			return 1000; end 		-- How much primary ammo is in the gun when it's spawned (Can be more than the clip can hold)
function getPrimaryAmmoType() 			return "pistol"; end	-- Primary ammo type; NOTE - this only matters when you plan on spawning more ammo for the gun later (i.e. using Gmod Plus), it does not effect the performance of the gun. (Pistol, 357, Buckshot, SMG1, smg1_grenade, AR2, AR2AltFire, XBowBolt, rpg_round, grenade, slam)
function getPrimaryScriptOverride()		return 1; end 			-- 0 = Don't override, shoot bullets, make sound and flash, 1 = Just make flash/sounds (no bullets), 2 = Just animations, 3 = Do nothing
function getTracerFreqPrimary()			return 1; end 			-- How often a primary ammo bullet is a tracer round (0 = no tracers, 1 = every bullet is a tracer, 2 = every other bullet is a tracer, etc.)
function getBulletSpread() 				return vector3(0.0, 0.0, 0.0); end 	-- Bullet spread, not view shake (X=down, Y=left, Z=clockwise spin)
function getViewKick() 					return vector3(-0.4, 0.0, 0.0); end -- Veiw kick for each shot(X=down, Y=left, Z=clockwise spin)
function getViewKickRandom() 			return vector3(0.0, 0.0, 0.0); end 	-- Veiw kick random (X=down, Y=left, Z=clockwise spin)
-- ==========================================
-- Secondary Fire Settings:
-- ==========================================
function getDamageSecondary()			return 0; end 		-- Secondary fire damage, per bullet
function getSecondaryShotDelay() 		return 0; end 		-- Delay between secondary fire shots (in seconds)
function getSecondaryIsAutomatic() 		return true; end 	-- Is secondary fire automatic? (can you hold down the mouse and it will fire repeatedly?)
function getNumShotsSecondary()			return 1; end 		-- Number of bullets per shot (the HL2 shotgun's secondary fire uses 14 for secondary fire)
function getMaxClipSecondary() 			return -1; end 		-- How much secondary ammo each clip can hold before you have to reload
function getDefClipSecondary() 			return -1; end 		-- How much secondary ammo is in the gun when it's spawned (Can be more than the clip can hold)
function getSecondaryAmmoType() 		return ""; end 		-- Secondary ammo type; NOTE - this only matters when you plan on spawning more ammo for the gun later (i.e. using Gmod Plus), it does not effect the performance of the gun. (Pistol, 357, Buckshot, SMG1, smg1_grenade, AR2, AR2AltFire, XBowBolt, rpg_round, grenade, slam)
function getSecondaryScriptOverride() 	return 3; end 		-- 0 = Don't override, shoot bullets, make sound and flash, 1 = Just make flash/sounds (no bullets), 2 = Just animations, 3 = Do nothing
function getTracerFreqSecondary()		return 0; end 		-- How often a secondary ammo bullet is a tracer round (0 = no tracers, 1 = every bullet is a tracer, 2 = every other bullet is a tracer, etc.)
function getBulletSpreadSecondary()		return vector3(0.0, 0.0, 0.0); end 	-- Secondary fire bullet spread, not view shake (X=down, Y=left, Z=clockwise spin)
function getViewKickSecondary() 		return vector3(0.0, 0.0, 0.0); end 	-- View kick for secondary fire (X=down, Y=left, Z=clockwise spin)
function getViewKickRandomSecondary() 	return vector3(0.0, 0.0, 0.0); end 	-- Veiw kick random for secondary fire (X=down, Y=left, Z=clockwise spin)
-- ==========================================
-- Names:
-- ==========================================
function getPrintName() 			return "Red paintball gun"; end 	-- What the weapon is called in the HUD weapons browser
function getClassName() 			return "Red paintball gun"; end 	-- What the weapons is called by the console when it reports a kill